VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4050
   ClientLeft      =   1950
   ClientTop       =   1680
   ClientWidth     =   5580
   LinkTopic       =   "Form1"
   ScaleHeight     =   4050
   ScaleWidth      =   5580
   Begin VB.ComboBox DeviceNum 
      Height          =   315
      Left            =   2880
      TabIndex        =   6
      Text            =   "Combo1"
      ToolTipText     =   "Select the Device Number that was assigned in the DriverLINX Configuration Panel"
      Top             =   720
      Width           =   1455
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop AI"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   600
      TabIndex        =   4
      Top             =   2040
      Width           =   1935
   End
   Begin VB.ListBox List1 
      Height          =   1815
      Left            =   2880
      TabIndex        =   3
      Top             =   1200
      Width           =   1815
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Start Continuous AI"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1440
      Width           =   1935
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   600
      TabIndex        =   0
      Top             =   720
      Width           =   1935
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   600
      Top             =   3360
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   600
      Top             =   2760
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   "DriverLINX Device Number: "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2880
      TabIndex        =   7
      Top             =   480
      Width           =   2175
   End
   Begin VB.Label Label2 
      BackColor       =   &H8000000E&
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   2280
      TabIndex        =   5
      Top             =   3240
      Width           =   3015
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   600
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration
' allocate array for the data and some other variables that will be needed
Dim AIData(8) As Single  ' still hard coding size of the array/buffers
Dim dummy As Single
Dim i As Integer

Private Sub cmdInit_Click()
' read in the device number we should use
Dim devNum As Integer
devNum = CInt(DeviceNum.Text)
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kmb1800"  ' give driver name to avoid Open DriverLINX dialog; use kmb1700 for DAS-1700
.Req_device = devNum
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With

If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
' use of the LDD control is not required
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh       ' load the LDD with data about our device
Form1.Caption = LDD.Dev_Model  'from the LDD, determine the model number
Label2.Caption = "Push Start."
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus  ' set focus back to our dialog
End Sub

Private Sub cmdSample_Click()

SetupAInonStop
SR.Refresh  ' start the task

' see Private Sub SR_BufferFilled() for what happens next
If SR.Res_result = DL_NoErr Then
cmdStop.Enabled = True
cmdSample.Enabled = False
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If

End Sub

Private Sub cmdStop_Click()
With SR
.Req_op = DL_STOP
.Refresh
End With
If SR.Res_result = DL_NoErr Then
cmdStop.Enabled = False
cmdSample.Enabled = True
End If
End Sub

Private Sub Form_Load()
' populate the combo box with legal DriverLINX device numbers 0..5
DeviceNum.AddItem "0", 0
DeviceNum.AddItem "1", 1
DeviceNum.AddItem "2", 2
DeviceNum.AddItem "3", 3
DeviceNum.AddItem "4", 4
DeviceNum.AddItem "5", 5
DeviceNum.ListIndex = 0  ' set the combo box equal to the first entry
' set a screen prompt
Label2.Caption = "Select Device and Push Initialize"
End Sub

Private Sub Form_Terminate()
'call code to stop the task just in case it is still running
cmdStop_Click
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAInonStop()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_INTERRUPT  ' could be DL_DMA if board has DMA feature
.Req_subsystem = DL_AI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_COMMAND  ' stop when Stop Operation is executed
' indeterminate sampling duration (stp on command or trigger) has
' impacts on buffering requirements
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each board has default timing channel
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase (5MHz for DAS-1800)
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
.Evt_Tim_rateOnCount = 0   ' not used for RATEGEN
.Evt_Tim_rateOutput = CT_Output_Default ' not used for RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 10) ' 10 Hz rate
' this example is pretty slow (10Hz)....if you go a lot faster, the size of the buffer
' will need to be increased!!!  Else Data Lost messages will result.
.Evt_Tim_ratePulses = 0  ' not used for RATEGEN
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 2                ' a start channel and stop channel
.Sel_chan_start = 0            ' start on channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
.Sel_chan_stop = 7
.Sel_chan_stopGainCode = .DLGain2Code(-1) 'stop on channel 7
' allocate three buffers of 8 samples each for the data
.Sel_buf_N = 3                 ' three buffers used, the minimum number for stop on command type task
.Sel_buf_samples = 8
' when stop condition is command or trigger, must have minimum of 3 buffers
' AND the total buffer size should approximate at least 1 second worth of data.
'
' After each buffer has been filled once, they will be recycled: 0, 1, 2, 0, 1, 2, etc.
'
' Example:  sampling at 10KHz.  You should have 10K samples worth of buffering in
' three or more buffers.
' these 10K samples can be in ten 1K buffers (100 msec buffer fill rate),
' or twenty 500 point buffers (50 msec buffer fill rate), etc.
'
' Two constraints:
' 1. don't make buffer size too small else they fill too quickly and
' buffer filled messages can not be processed that fast.  Keep it above 10msec.
'
' 2.  the buffer MUST be a multiple of how many channels are in the scan, e.g., 8, 16, etc.
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

List1.Clear  ' clear the list box
Label2.Caption = "Processing buffer #: " & Str(bufIndex)
' the BufferFilled message contains the bufIndex that is ready for conversion
dummy = SR.VBArrayBufferConvert(bufIndex, 0, 8, AIData, DL_tSINGLE, 0, 0)
For i = 0 To 7
List1.AddItem "chan #: " & Str(i) & "  " & Str(Format(AIData(i), "#0.##0"))
Next i
' for the sample rate, assign buffer size so that BufferFilled messages are not
' sent at a rate faster than is practical for Windows message queue processing,
' e.g., not faster than appx 10 msec rate
End Sub

Private Sub SR_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
' a Data Lost message could result if buffer size is too small for the
' the requested sample rate
'
MsgBox "Data Lost Message has Occured...try increasing size of or number of buffers", vbOKOnly
'
' could just restart the acquisition from here or take other corrective actions
'With SR
'.Req_op = DL_START
'.Refresh
'End With
End Sub
